<?php
function getAllUsers()
{
   $sock = Login();
   checkActionAccess($sock, "read");

   $arr = ParamGet($sock, "security");
   $users = [];
   $users = $arr->security->user;
   $users = array_sort_by_accesslevel($users);
   foreach ($users as $key => $value) {
      if ($value->accesslevel != 1) {
         $value->accesslevel = $value->accesslevel / 10;
      }
      unset($value->password);
      unset($value->txlimit);
      unset($value->enabled);

      if (isset($value->deny)) {
         unset($value->deny);
      }

      $value->login = ConvertNative2UTF($value->login);
      $value->login = str_replace("?", "И", $value->login);
   }
   socket_close($sock);
   return $users;
}
function getAllUsersServers($arr)
{
   $users = [];
   $users = $arr->security->user;
   $users = array_sort_by_accesslevel($users);
   foreach ($users as $key => $value) {
      if ($value->accesslevel != 1) {
         $value->accesslevel = $value->accesslevel / 10;
      }
      unset($value->password);
      unset($value->txlimit);
      unset($value->enabled);

      if (isset($value->deny)) {
         unset($value->deny);
      }

      $value->login = ConvertNative2UTF($value->login);
      $value->login = str_replace("?", "И", $value->login);
   }

   return $users;
}

function getUser($id)
{
   $sock = Login();
   checkActionAccess($sock, "read");

   $idUsers = $id;
   $security = ParamGet($sock, "security");
   $user = GetUserById($idUsers, $security);
   /* echo json_encode($user);  */
   $data = "{}";
   $json = json_decode($data, true);
   $json["index"] = $user->index;
   $json["login"] = ConvertNative2UTF($user->login);
   $json["accesslevel"] = $user->accesslevel != 1 ? $user->accesslevel / 10 : $user->accesslevel;
   $json["id"] = $user->id;

   if (isset($user->txlimit)) {
      $txlimit = round(($user->txlimit * 8) / 1000000);
      $json["txlimit"] = $txlimit;
   } else {
      $json["txlimit"] = 0;
   }

   if (isset($user->deny) && isset($user->deny->net) && isset($user->deny->net->adapters)) {
      $adapters = $user->deny->net->adapters;
      $json["adapters"] = $adapters;
   } else {
      $json["adapters"] = 0;
   }

   socket_close($sock);
   return $json;
}

function getAllUsersMulti()
{
   $sock = Login();
   checkActionAccess($sock, "read");

   $arr = ParamGet($sock, "security");
   $users = [];
   $users = $arr->security->user;
   $users = array_sort_by_accesslevel($users);

   foreach ($users as $key => $value) {
      $value->accesslevel = $value->accesslevel != 1 ? $value->accesslevel / 10 : $value->accesslevel;
      $value->txlimit = isset($value->txlimit) ? round(($value->txlimit * 8) / 1000000) : 0;

      if (isset($value->deny) && isset($value->deny->net) && isset($value->deny->net->adapters)) {
         $adapters = $value->deny->net->adapters;
         $json["adapters"] = $adapters;
      } else {
         $json["adapters"] = 0;
      }

      $value->login = ConvertNative2UTF($value->login);
      $value->login = str_replace("?", "И", $value->login);

      unset($value->enabled);
      unset($value->password);
   }
   socket_close($sock);
   return $users;
}

function getAccess()
{
   $sock = Login();
   checkActionAccess($sock, "read");
   global $UserAccessLevel;
   $access = 1;
   if (intval($UserAccessLevel) == 101) {
      $access = 11;
   } elseif (intval($UserAccessLevel) != 1 && intval($UserAccessLevel) != 0) {
      $access = intval($UserAccessLevel) / 10;
   }
   socket_close($sock);
   return $access;
}
function getExist()
{
   $sock = Login();
   $url = $_SERVER["REQUEST_URI"];
   checkActionAccess($sock, "write");
   $params = explode("/", $url);
   $userLogin = $params[count($params) - 2];
   $users = ParamGet($sock, "security");
   $users = $users->security->user;
   $result = 0;
   foreach ($users as $user) {
      $login = ConvertNative2UTF($user->login);
      $login = str_replace("?", "И", $login);
      if ($login == $userLogin) {
         $result = 1;
      }
   }
   socket_close($sock);
   return $result;
}
function getConnectedClient()
{
   $sock = Login();

   if (!accessServerCheck("CHECK_WRITE")) {
      Header("HTTP/1.0 403 Forbidden");
      die("You have no rights!");
   }

   $arr = ParamGet($sock, "ClientInfo");
   $clients = isset($arr->ClientInfo) ? $arr->ClientInfo : [];
   $arr_users = ParamGet($sock, "security");
   $users = $arr_users->security->user;
   if (count($clients) > 0) {
      foreach ($clients as $k) {
         $name = "login";
         foreach ($users as $u) {
            if ($u->id == $k->uid) {
               $str_utf = ConvertNative2UTF($u->login);
               $k->$name = $str_utf;

               break;
            }
         }
      }
   }
   socket_close($sock);
   if ($arr->ClientInfo != []) {
      return $arr;
   }
   $arr->ClientInfo = ["none"];
   return $arr;
}
function getConnected()
{
   $sock = Login();

   if (!accessServerCheck(CHECK_WRITE)) {
      Header("HTTP/1.0 403 Forbidden");
      die("You have no rights!");
   }

   $arr_users = ParamGet($sock, "security");
   $arr = ParamGet($sock, "ClientInfo");
   socket_close($sock);

   $clients = $arr->ClientInfo;
   $users = $arr_users->security->user;
   foreach ($clients as $k) {
      $name = "login";
      foreach ($users as $u) {
         if ($u->id == $k->uid) {
            $str_utf = ConvertNative2UTF($u->login);
            $str_utf = str_replace("?", "И", $str_utf);
            $k->$name = $str_utf;
            break;
         }
      }
   }
   if ($arr->ClientInfo != []) {
      return $arr;
   } else {
      $arr->ClientInfo = ["none"];
      return $arr;
   }
}
